/*
 * Decompiled with CFR 0.152.
 */
package pse.model;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringWriter;
import org.w3c.dom.Node;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public abstract class ModelObject {
    public abstract String getElementName();

    public abstract String getDtdName();

    public void addXmlDeclarations(XmlWriter xmlWriter) {
        xmlWriter.addXmlDeclaration();
        xmlWriter.addDocumentTypeDeclaration(this.getElementName(), this.getDtdSource() + this.getDtdName());
    }

    public String getDtdSource() {
        return "https://www.netacad-data.net/dtd/panther/";
    }

    public void fromParentNode(Node node) {
        Node node2 = XmlUtils.getChild(node, this.getElementName());
        if (node2 != null) {
            this.fromMyNode(node2);
        }
    }

    public void fromMyNode(Node node) {
        this.readAttributes(node);
        this.readChildrenFromMyNode(node);
        this.readText(node);
    }

    public void read(String string, String string2) throws Exception {
        Node node = XmlUtils.parseToNode(string, string2);
        this.fromMyNode(node);
    }

    public void read(String string, Reader reader) throws Exception {
        Node node = XmlUtils.parseToNode(string, reader);
        this.fromMyNode(node);
    }

    public void read(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        this.read(file.getCanonicalPath(), fileReader);
        ((Reader)fileReader).close();
    }

    public boolean isTrivial() {
        return !this.isNonTrivial();
    }

    public boolean isNonTrivial() {
        return this.hasAttributes() || this.hasChildren() || this.hasText();
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasText() {
        return false;
    }

    public boolean nonEmptyString(String string) {
        return string != null && string.length() > 0;
    }

    protected void addChild(XmlWriter xmlWriter, ModelObject modelObject) {
        modelObject.toXmlString(xmlWriter);
    }

    protected void addNullableChild(XmlWriter xmlWriter, ModelObject modelObject) {
        if (modelObject != null) {
            modelObject.toXmlString(xmlWriter);
        }
    }

    protected void addOptionalChild(XmlWriter xmlWriter, ModelObject modelObject) {
        if (modelObject != null && !modelObject.isTrivial()) {
            modelObject.toXmlString(xmlWriter);
        }
    }

    protected String escapeCData(String string) {
        return string.replace("]]>", "]]&gt;");
    }

    protected ModelObject readChild(Node node, ModelObject modelObject) {
        modelObject.fromParentNode(node);
        return modelObject;
    }

    protected ModelObject readChildFromChildNode(Node node, ModelObject modelObject) {
        modelObject.fromMyNode(node);
        return modelObject;
    }

    protected ModelObject readOptionalChild(Node node, ModelObject modelObject) {
        modelObject.fromParentNode(node);
        return modelObject.isTrivial() ? null : modelObject;
    }

    protected String unescapeCData(String string) {
        return string.replace("]]&gt;", "]]>");
    }

    public String toXmlString() {
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter, "", "  ");
        this.toXmlString(xmlWriter);
        return stringWriter.toString();
    }

    public String toXmlStringWithDocType() {
        StringWriter stringWriter = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(stringWriter, "", "  ");
        this.addXmlDeclarations(xmlWriter);
        this.toXmlString(xmlWriter);
        return stringWriter.toString();
    }

    public void toXmlString(XmlWriter xmlWriter) {
        xmlWriter.startElement(this.getElementName());
        this.addAttributes(xmlWriter);
        if (this.hasChildren() || this.hasText()) {
            xmlWriter.stopElement();
            this.addChildren(xmlWriter);
            this.addText(xmlWriter);
            xmlWriter.closeElement();
        } else {
            xmlWriter.stopAndCloseElement();
        }
    }

    protected void addAttributes(XmlWriter xmlWriter) {
    }

    protected void addChildren(XmlWriter xmlWriter) {
    }

    protected void addText(XmlWriter xmlWriter) {
    }

    protected void readAttributes(Node node) {
    }

    protected void readChildrenFromMyNode(Node node) {
    }

    protected void readText(Node node) {
    }
}

